#ifndef __string_h__
#include "DString.h"
#endif
#include <string.h>
#include <stdio.h>
/*
  *******************************************************************
  *         Mthodes relatives  la classe String                 *
  *******************************************************************
*/
// -----> append
//
// SE : ajoute la chaine passe a la fin de la String
void String::append(char *aString)
 { if (aString == 0)
      return;
	if (strlen(aString) + strlen(value) + 1 >= memLenght)
	 { int    newSize  = (int) ((float)(memLenght + strlen(aString)+1) * 1.5);
		char   *ptTmp = new char [newSize];
		strcpy(ptTmp,value);
		value = ptTmp;
		memLenght = newSize;
	 }
	strcat(value,aString);
 }
// -----> constructeur
//
// SE :
String::String()
 { value = new char[SIMPLESTRING_BLOCK_SIZE];
	memLenght = SIMPLESTRING_BLOCK_SIZE;
	*value = 0;
 }
//
String::String(unsigned long aSize)
 { if (aSize < SIMPLESTRING_MIN_BLOCK_SIZE)
		aSize = SIMPLESTRING_MIN_BLOCK_SIZE;
	value = new char[aSize];
	memLenght = aSize;
	*value = 0;
 }
//
String::String(const char *aString)
 { if (aString == 0)
	 { value = new char[SIMPLESTRING_BLOCK_SIZE];
		memLenght = SIMPLESTRING_BLOCK_SIZE;
		*value = 0;
		return;
	 }
	else
	 { value = new char [strlen(aString) + 1];
		memLenght = strlen(aString) + 1;
		strcpy(value,aString);
	 }
 }
String::String(String &aStr)
 { value = new char [strlen(aStr) + 1];
	memLenght = strlen(aStr) + 1;
	strcpy(value,aStr);
 }
// -----> destructeur
//
// SE :
String::~String()
 {
	 if (value)
		delete [] value;
 }
// -----> operator +=
//
// SE :
String &String::operator+=(String &aNPS)
 { append(aNPS);
	return *this;
 }
String &String::operator+=(char *aString)
 { append(aString);
	return *this;
 }
String &String::operator+=(char aChar)
 { char   buffer[2];
	buffer[0] = aChar;
	buffer[1] = 0;
	append(buffer);
	return *this;
 }
String &String::operator+=(int anInt)
 { char 			buffer[50];
	sprintf(buffer,"%d",anInt);
	append(buffer);
	return *this;
 }
// -----> operator =
//
// SE :
String &String::operator=(String &aNPS)
 { *value = 0;
	append(aNPS);
	return *this;
 }
String &String::operator=(char *aString)
 { *value = 0;
	append(aString);
	return *this;
 }
String &String::operator=(char aChar)
 { char   buffer[2];
	buffer[0] = aChar;
	buffer[1] = 0;
	*value = 0;
	append(buffer);
	return *this;
 }
// SE : avec int
String &String::operator=(int anInt)
 { char 			buffer[50];
	sprintf(buffer,"%d",anInt);
	operator=(buffer);
	return *this;
 }
// -----> size
//
// SE : renvoie la taille de la mmoire alloue pour la chaine
unsigned long String::size()
 { return memLenght;
 }

/*
 *
 * SETTING
 *
 */


// -----> operator ==
//
// SE :
int String::operator==(String &aNPS)
 { return !strcmp(value,aNPS);
 }
int String::operator==(char *aString)
 { if (aString == 0)
 		return 0;
   return !strcmp(value,aString);
 }
int String::operator==(char aChar)
 { char buffer[2];
   buffer[0] = aChar;
   buffer[1] = 0;
   return !strcmp(value,buffer);
 }
// -----> setSize
//
// SE : fixe la taille de la chaine  aSize et l'initialise avec ""
void String::setSize(unsigned long aSize)
 { if (value)
		delete [] value;
	memLenght = 0;
	value = new char [aSize];
	memLenght =  aSize;
	*value = 0;
 }
// -----> lenght
//
// SE : retourne la taille de la chaine (\0 non compris)
unsigned long String::lenght()
 { return strlen(value);
 }
// -----> operator []
//
// SE :
char & String::operator[](unsigned long index)
 { return value[index];
 }
// -----> operator >>
//
// SE :
istream &operator >>(istream &input, String &aString)
 { char buffer[1024];
 	input >> buffer;
   aString = buffer;
   return input;
 }
// -----> operator <<
//
// SE :
ostream &operator <<(ostream &output, String &aString)
 { output << (char*)aString;
   return output;
 }

